#ifndef HELI_H
#define HELI_H

#include "rosterdir.h"
#include "explosive.h"
#include <atomdir.h>
#include <dactuator.h>
#include "bulletgun.h"

struct Heli : public Explosive {
	float x;
	float y;
	float force;
	RosterDir *aim;
	AtomDir *up;
	DActuator *engine;
	DActuator *tail;
	Atom *tail_atom;
	float oix, oiy;
	Roster *target;
	BulletGun *gun;
	bool fire;
	int temp;
	bool bulletlevels[MAXLEVELS];
	int burst;

	Heli(Object *parent, Roster *target = NULL);
	virtual void stepFunc();
	virtual void addAtom(Atom *a);
	virtual void addLink(Link *l);
	virtual void addPoly(Poly *p);
};

#endif